VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   8055
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10800
   LinkTopic       =   "Form1"
   ScaleHeight     =   8055
   ScaleWidth      =   10800
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkFitToCurve 
      Caption         =   "Fit Text to Curve-Length"
      Height          =   315
      Left            =   6300
      TabIndex        =   7
      Top             =   510
      Value           =   1  'Aktiviert
      Width           =   2235
   End
   Begin VB.TextBox txtCurved 
      Height          =   345
      Left            =   90
      TabIndex        =   6
      Top             =   480
      Width           =   6105
   End
   Begin VB.CheckBox chkShowCurve 
      Caption         =   "Show Curve"
      Height          =   285
      Left            =   6300
      TabIndex        =   5
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   1335
   End
   Begin VB.CheckBox chkClamp 
      Caption         =   "Clamp"
      Height          =   285
      Left            =   5100
      TabIndex        =   3
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   945
   End
   Begin VB.ComboBox cmbDamping 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   3300
      List            =   "fCairoDemo.frx":0013
      Style           =   2  'Dropdown-Liste
      TabIndex        =   2
      Top             =   60
      Width           =   1335
   End
   Begin VB.CheckBox chkMeetPoints 
      Caption         =   "Meet ControlPoints"
      Height          =   315
      Left            =   90
      TabIndex        =   1
      Top             =   90
      Width           =   1815
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   3945
      Left            =   30
      TabIndex        =   0
      Top             =   1050
      Width           =   8175
      _ExtentX        =   14473
      _ExtentY        =   7646
   End
   Begin VB.Label Label1 
      Caption         =   "BSpline-Enum"
      Height          =   285
      Left            =   2220
      TabIndex        =   4
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private CPs() As cControlPoint

Private Sub Form_Load()
  Caption = "Drag the Control-Points"
  Me.ScaleMode = vbPixels

Dim i&
  Rnd -9
  ReDim CPs(0 To 6)
  For i = 0 To UBound(CPs) 'create 7 controlpoints (y randomized)
    Set CPs(i) = ucCanvas1.ControlPoints.Add("P" & i, i * 90 + 50, 30 + Rnd * 350, vbBlue, 6)
  Next i
  
  'overwrite the default blue-color of the first and last ControlPoint
  CPs(0).Color = vbGreen: CPs(UBound(CPs)).Color = vbGreen
  
  cmbDamping.ListIndex = 3
  txtCurved.Text = "A Text-Path, projected from a BSpline-Curve --> (acting as the BaseLine)"
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

'------- the different "Control-Changed"-Events all doing the same refresh, a simple: Draw ucCanvas.CC ----------
Private Sub chkMeetPoints_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub cmbDamping_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub chkClamp_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub chkShowCurve_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub txtCurved_Change()
  Draw ucCanvas1.CC
End Sub

Private Sub chkFitToCurve_Click()
  Draw ucCanvas1.CC
End Sub
'------------- End of "Control-Changed"-Event-Handling ------------------


Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim i&, PolyArr() As Double
Dim CurvePath As cCairoPath, CurveLength As Double, CurveDistances() As Double
Dim TextPath As cCairoPath, TextWidth As Double


  'just a simple copy-over from the ControlPoint-Coords into a consecutive XY-PolyArray
  ReDim PolyArr(0 To 2 * ucCanvas1.ControlPoints.Count - 1)
  For i = 0 To UBound(CPs)
    PolyArr(2 * i) = CPs(i).X
    PolyArr(2 * i + 1) = CPs(i).Y
  Next i
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  'just some common LineHandling-preprations beforehand
  CC.SetLineCap CAIRO_LINE_CAP_ROUND
  CC.SetLineJoin CAIRO_LINE_JOIN_ROUND
  
  
  CC.Save
  
    'create just the "pure" BSpline-Path (no filling and no stroking - only the Path-Coords)...
    CC.Polygon PolyArr, False, cmbDamping.ListIndex, (chkClamp.Value = 1), (chkMeetPoints.Value = 1)
      Set CurvePath = CC.CopyPath(True, 0.02) '...copy the path from the CC...
    CC.ClearPath '...and clear the Path from the CC
    
    'same here, only the pure TextPath (the Coords) is getting copied (no filling)
    CC.SelectFont "Times New Roman", 20
    CC.TextOut 0, -3, txtCurved.Text, True, 1, True  '<- note the last TextOut-Param
      Set TextPath = CC.CopyPath()
    CC.ClearPath

    'note, that in the above Copy-Operations, the BSpline-CurvePath (later on acting as our Text-Baseline)
    'was copied with CC.CopyPath(True) <- the True-Param ensures a Flattened-Path, which allows an
    'easier Path-Length-reconstruction later on, when we calculate the Projection. If the cairo-lib
    'was told, to deliver a Flattened-Path, then we get back a path, which does *not* consists of
    'any Bezier-Curve-Path-elements - such curve-segments are instead replaced by a (longer) sequence
    'of (very short) Line-Segments (so, only MoveTo-LineTo-sequences remaining in the path - and their
    '"resolution" dependent on the second optional Parameter: FlatPrecision - having a default of 0.1)

    
    'Ok, now back to the real drawing operations (this time directly from already "cached" Path-objects)
    
    If chkShowCurve.Value Then
      'first the BSpline-Curve (without performing any changes on the internally stored Path-Coords)
      CC.AppendPath CurvePath 'now the Path is back again on the Cairo-Context
        CC.SetSourceColor vbRed 'and as usual we prepare some color-settings...
        CC.SetLineWidth 4 '... and the current Line-Width-info...
      CC.Stroke 'and finally the Stroke, which draws the Line-Color along the path
    End If
    
    'And perhaps these are the lines you were waiting for... ;-)
    'here we perform the transformation of the TextPath-Coords, according to the Base-Coords from 'CurvePath'
    '(with a small precalculation, to achieve a Text-Fitting to the Curve-Length if the User wants that)
    If chkFitToCurve.Value = 0 Then
      TextPath.ProjectPathData_Using CurvePath
    Else
      CurveLength = CurvePath.CalculateDistances(CurveDistances)
      TextWidth = CC.GetTextExtents(txtCurved.Text)
      If TextWidth > 0 Then TextPath.ProjectPathData_Using CurvePath, CurveLength / TextWidth
    End If
    
    'the now already done Coord-Projection was performed directly on the TextPath-Objects-internal Coords-Array...
    '...what remains is the visual Output - done in the same way as before (with the CurvePath above)...
    CC.AppendPath TextPath
      CC.SetSourceColor &H202020
    CC.Fill '...only difference is, that we do only a fill here on the TextPath-Glyphs (no stroke, which would also be possible)
  
  CC.Restore
  
  ucCanvas1.Refresh '<- drawing of the current Control-points is "hidden" within this Refresh-method of the canvas
End Sub
